/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry.PrimitiveState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.SceneGraphObject;

public class SphereState
extends PrimitiveState {
    private float radius;
    private int divisions;
    private int bodyAppearance;

    public SphereState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.bodyAppearance = controller.getSymbolTable().addReference(((Sphere)this.node).getShape(0).getAppearance());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.bodyAppearance);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.bodyAppearance = dataInput.readInt();
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeFloat(((Sphere)this.node).getRadius());
        dataOutput.writeInt(((Sphere)this.node).getDivisions());
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.radius = dataInput.readFloat();
        this.divisions = dataInput.readInt();
    }

    public void buildGraph() {
        ((Sphere)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
        super.buildGraph();
    }

    public SceneGraphObject createNode(Class clazz) {
        Sphere sphere = (Sphere)this.createNode(clazz, new Class[]{Float.TYPE, Integer.TYPE, Integer.TYPE, Appearance.class}, new Object[]{new Float(this.radius), new Integer(this.primflags), new Integer(this.divisions), null});
        return sphere;
    }

    protected SceneGraphObject createNode() {
        return new Sphere(this.radius, this.primflags, this.divisions, null);
    }
}

